/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.client.pi.PIHSCCECCIMClient;
import com.ibm.hsc.cim.client.pi.PIHSCIOCIMClient;
import com.ibm.hsc.client.PIIOBusDataBean;
import com.ibm.hsc.client.PIIODrawerConfigIdDataBean;
import com.ibm.hsc.client.PIIODrawerDataBean;
import com.ibm.hsc.client.PIIOSlotDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CECInfo;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.PartitionInfo;
import com.ibm.hsc.common.util.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class CIMUtils {
    public static final char MACHINE_TYPE_MODEL_AND_SERIAL_SEPARATOR_CHAR = '_';
    public static final char CIM_MACHINE_TYPE_MODEL_AND_SERIAL_SEPARATOR_CHAR = '*';
    public static final char MTM_SEPARATOR = '-';
    public static final char CIM_PARTITION_NAME_SEPARATOR_CHAR = '*';
    private static final String TRACE_MASKD = "JCIMUTLD";
    private static final String TRACE_MASKF = "JCIMUTLF";
    private static final String TRACE_MASKT = "JCIMUTLT";
    private static String savedHMCMTMS = null;

    private CIMUtils() {
    }

    public static void main(String[] stringArray) {
        Vector vector = null;
        CECInfo cECInfo = null;
        Hashtable hashtable = null;
        try {
            Object object;
            PIHscUtil.initHscUtil(3);
            vector = CIMUtils.getCECsInfo();
            if (vector != null && vector.size() > 0) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    cECInfo = (CECInfo)object.nextElement();
                    System.out.println("Got CEC by getCECsInfo: " + cECInfo.getCECModelType() + ", " + cECInfo.getCECSerialNumber() + ", " + cECInfo.getCECMachineName());
                }
            } else {
                System.out.println("No CECs found by getCECsInfo.");
            }
            if ((vector = CIMUtils.getCECs()) != null && vector.size() > 0) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    System.out.println("Got CEC by getCECs: " + (String)object.nextElement());
                }
            } else {
                System.out.println("No CECs found by getCECs.");
            }
            if ((hashtable = CIMUtils.getPartitionInfo()) != null) {
                object = hashtable.values().iterator();
                while (object.hasNext()) {
                    System.out.println("Got partition by getPartitionInfo: " + (PartitionInfo)object.next());
                }
            } else {
                System.out.println("No partitions found by getPartitionInfo.");
            }
            if (stringArray.length >= 2) {
                System.out.println("HMC MTMS is " + CIMUtils.getHMCMTMS(stringArray[0], stringArray[1]));
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
    }

    public static Vector getCECsInfo() throws CIMException {
        Enumeration enumeration = null;
        Vector vector = null;
        Vector<CECInfo> vector2 = null;
        Vector vector3 = null;
        Vector<String> vector4 = null;
        vector4 = new Vector<String>(3);
        vector4.addElement("PlatformType");
        vector4.addElement("PlatformSerial");
        vector4.addElement("UserDefinedName");
        enumeration = CIMUtils.getInstances("IBMHSC_ComputerSystem");
        vector = CIMUtils.getValues(enumeration, vector4);
        if (vector != null) {
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                vector3 = (Vector)enumeration2.nextElement();
                if (vector2 == null) {
                    vector2 = new Vector<CECInfo>();
                }
                vector2.addElement(new CECInfo((String)vector3.elementAt(0), (String)vector3.elementAt(1), (String)vector3.elementAt(2)));
            }
        }
        return vector2;
    }

    public static Vector getCECs() throws CIMException {
        Enumeration enumeration = null;
        Vector vector = null;
        Vector<String> vector2 = null;
        Vector vector3 = null;
        Vector<String> vector4 = null;
        vector4 = new Vector<String>(2);
        vector4.addElement("PlatformType");
        vector4.addElement("PlatformSerial");
        enumeration = CIMUtils.getInstances("IBMHSC_ComputerSystem");
        vector = CIMUtils.getValues(enumeration, vector4);
        if (vector != null) {
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                vector3 = (Vector)enumeration2.nextElement();
                if (vector2 == null) {
                    vector2 = new Vector<String>();
                }
                vector2.addElement((String)vector3.elementAt(0) + '_' + (String)vector3.elementAt(1));
            }
        }
        return vector2;
    }

    public static Vector getHSCs(String string, String string2) throws CIMException, PIHscClientException {
        Hashtable hashtable;
        Object object;
        Vector<Hashtable<String, String>> vector = null;
        Hashtable<String, String> hashtable2 = null;
        Hashtable<String, String> hashtable3 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = CIMUtils._getHostName();
        String string7 = string + '*' + string2;
        CIMObjectPath cIMObjectPath = null;
        Vector<CIMProperty> vector2 = null;
        Vector vector3 = null;
        CIMValue cIMValue = null;
        int n = 65535;
        String string8 = null;
        StringTokenizer stringTokenizer = null;
        String string9 = "HscIPAddr=";
        String string10 = "HscName=";
        String string11 = "HmcStat=";
        cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscS1_0");
        if (cIMObjectPath == null) {
            throw new CIMException("Unable to determine HMCs");
        }
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath.addKey("Name", new CIMValue((Object)string7));
        vector2 = new Vector<CIMProperty>();
        vector3 = new Vector();
        vector2.setSize(1);
        vector2.setElementAt(new CIMProperty("SlotID", new CIMValue((Object)new UnsignedInt16(n))), 0);
        cIMValue = PIHscUtil.invokeCIMMethod(string6, cIMObjectPath, "GetOnePHYPHmcInfo", vector2, vector3);
        if (cIMValue == null) {
            throw new CIMException("Unable to determine HMCs");
        }
        string8 = (String)cIMValue.getValue();
        stringTokenizer = new StringTokenizer(string8, ";");
        while (stringTokenizer.hasMoreElements()) {
            object = stringTokenizer.nextToken();
            if (((String)object).startsWith(string9)) {
                string4 = ((String)object).substring(string9.length());
                continue;
            }
            if (((String)object).startsWith(string10)) {
                string3 = ((String)object).substring(string10.length());
                continue;
            }
            if (!((String)object).startsWith(string11)) continue;
            string5 = ((String)object).substring(string11.length());
        }
        if (string5 == null || string5.length() == 0 || string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0) {
            throw new CIMException("Unable to determine HMCs");
        }
        if ((string3 = CIMUtils.replaceFirst(string3, '*', '_')).indexOf(45) == -1 && string3.length() >= 4) {
            string3 = string3.substring(0, 4) + "-" + string3.substring(4);
        }
        hashtable2 = new Hashtable<String, String>(1);
        hashtable2.put(string4, string3);
        if (hashtable2 != null) {
            vector = new Vector<Hashtable<String, String>>(2);
            vector.addElement(hashtable2);
        }
        if ((hashtable = ((PIHSCCECCIMClient)(object = PIHSCCECCIMClient.createInstance(string6, string7, true, "root/ibmhscS1_0"))).getAllPHYPHmcInfo()) == null) {
            throw new CIMException("Unable to determine HMCs");
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            string4 = null;
            string3 = null;
            string5 = null;
            string8 = (String)enumeration.nextElement();
            stringTokenizer = new StringTokenizer(string8, ";");
            while (stringTokenizer.hasMoreElements()) {
                String string12 = stringTokenizer.nextToken();
                if (string12.startsWith(string9)) {
                    string4 = string12.substring(string9.length());
                    continue;
                }
                if (string12.startsWith(string10)) {
                    string3 = string12.substring(string10.length());
                    continue;
                }
                if (!string12.startsWith(string11)) continue;
                string5 = string12.substring(string11.length());
            }
            if (string5 == null || string5.length() == 0 || string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0 || !string5.equals("1")) continue;
            if ((string3 = CIMUtils.replaceFirst(string3, '*', '_')).indexOf(45) == -1 && string3.length() >= 4) {
                string3 = string3.substring(0, 4) + "-" + string3.substring(4);
            }
            if (hashtable2.containsKey(string4)) continue;
            if (hashtable3 == null) {
                hashtable3 = new Hashtable<String, String>();
                vector.addElement(hashtable3);
            }
            hashtable3.put(string4, string3);
        }
        return vector;
    }

    public static CIMInstance getInstance(String string, Hashtable hashtable) throws CIMException {
        CIMObjectPath cIMObjectPath = null;
        CIMInstance cIMInstance = null;
        String string2 = null;
        String string3 = null;
        String string4 = CIMUtils._getHostName();
        cIMObjectPath = new CIMObjectPath(string, "root/ibmhscS1_0");
        if (cIMObjectPath != null) {
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    string3 = (String)hashtable.get(string2);
                    cIMObjectPath.addKey(string2, new CIMValue((Object)string3));
                }
            }
            cIMInstance = PIHscUtil.getCIMInstance(string4, cIMObjectPath, false);
        }
        return cIMInstance;
    }

    public static Enumeration getAssociators(String string, String string2, String string3, Hashtable hashtable) throws CIMException {
        CIMObjectPath cIMObjectPath = null;
        String string4 = null;
        String string5 = null;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        String string6 = CIMUtils._getHostName();
        enumeration = new Vector().elements();
        cIMObjectPath = new CIMObjectPath(string, "root/ibmhscS1_0");
        if (cIMObjectPath != null) {
            if (hashtable != null) {
                Enumeration enumeration3 = hashtable.keys();
                while (enumeration3.hasMoreElements()) {
                    string4 = (String)enumeration3.nextElement();
                    string5 = (String)hashtable.get(string4);
                    cIMObjectPath.addKey(string4, new CIMValue((Object)string5));
                }
            }
            if ((enumeration2 = PIHscUtil.getCIMAssociation(string6, cIMObjectPath, string2, string3, null, null)) != null) {
                return enumeration2;
            }
        }
        return enumeration;
    }

    public static Vector getIODrawers(String string, String string2) throws CIMException {
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration = null;
        Vector vector = null;
        Vector<String> vector2 = null;
        Vector<String> vector3 = null;
        vector3 = new Vector<String>(1);
        vector3.addElement("DeviceID");
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        enumeration = CIMUtils.getAssociators("IBMHSC_ComputerSystem", "IBMHSC_CompSysIODrawer", "IBMHSC_IODrawer", hashtable);
        vector = CIMUtils.getValues(enumeration, vector3);
        if (vector != null) {
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string3;
                if (vector2 == null) {
                    vector2 = new Vector<String>();
                }
                String string4 = (String)((Vector)enumeration2.nextElement()).elementAt(0);
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "I/O drawers found in getIODrawers :" + string4);
                }
                if (string4.indexOf(string) != -1) continue;
                int n = string4.length();
                if (string4.endsWith("-P1") || string4.endsWith("-P2")) {
                    n -= 3;
                }
                if (vector2.contains(string3 = CIMUtils.replaceFirst(string4 = string4.substring(0, n), '*', '_'))) continue;
                vector2.addElement(string3);
            }
        } else if (Trace.LEVEL >= 3) {
            Trace.trace(TRACE_MASKD, "no I/O drawers found in getIODrawers.");
        }
        return vector2;
    }

    public static Vector getUnallocatedIODrawers(String string, String string2) throws PIHscClientException {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        Vector<String> vector = null;
        Date date = null;
        String string11 = CIMUtils._getHostName();
        String string12 = string + '*' + string2;
        PIHSCCECCIMClient pIHSCCECCIMClient = PIHSCCECCIMClient.createInstance(string11, string12, true, "root/ibmhscS1_0");
        PIIODrawerConfigIdDataBean pIIODrawerConfigIdDataBean = new PIIODrawerConfigIdDataBean();
        PIIODrawerConfigIdDataBean[] pIIODrawerConfigIdDataBeanArray = pIHSCCECCIMClient.getIoDrawerConfigIdAndMtms(pIIODrawerConfigIdDataBean.getAllKeys());
        date = new Date();
        vector = new Vector<String>();
        vector.addElement("*FC ????????\n*VC 20.0\n*N2 " + date + "\n");
        for (int i = 0; i < pIIODrawerConfigIdDataBeanArray.length; ++i) {
            string4 = pIIODrawerConfigIdDataBeanArray[i].getDrawerModel();
            string5 = pIIODrawerConfigIdDataBeanArray[i].getDrawerType();
            string6 = pIIODrawerConfigIdDataBeanArray[i].getDrawerSerialNum();
            string8 = pIIODrawerConfigIdDataBeanArray[i].getLoaction_code();
            string3 = string4 == null || string5 == null ? "" : string5 + '-' + string4;
            if (string6 == null) {
                string6 = "";
            }
            if (string6.endsWith("-P1") || string6.endsWith("-P2")) {
                string6 = string6.substring(0, string6.length() - 3);
            }
            Hashtable hashtable = null;
            String[] stringArray = new String[]{string8};
            PIHSCIOCIMClient pIHSCIOCIMClient = PIHSCIOCIMClient.createInstance(string11, string12, stringArray, null, null, true, "root/ibmhscS1_0");
            hashtable = pIHSCIOCIMClient.getIODrawerDataBeanHash(true);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                PIIODrawerDataBean pIIODrawerDataBean = (PIIODrawerDataBean)enumeration.nextElement();
                Hashtable hashtable2 = pIIODrawerDataBean.getBuses();
                Enumeration enumeration2 = hashtable2.elements();
                while (enumeration2.hasMoreElements()) {
                    PIIOBusDataBean pIIOBusDataBean = (PIIOBusDataBean)enumeration2.nextElement();
                    Hashtable hashtable3 = pIIOBusDataBean.getSlots();
                    Enumeration enumeration3 = hashtable3.elements();
                    while (enumeration3.hasMoreElements()) {
                        PIIOSlotDataBean pIIOSlotDataBean = (PIIOSlotDataBean)enumeration3.nextElement();
                        if (pIIOSlotDataBean.getOwner().intValue() != 65535 || pIIOSlotDataBean.getPciVendorId().intValue() == 65535 && pIIOSlotDataBean.getPciDeviceId().intValue() == 65535) continue;
                        string7 = pIIOSlotDataBean.getLocation();
                        if (string7 == null) {
                            string7 = "";
                        }
                        if ((string10 = pIIOSlotDataBean.getBestKnownDescription()) == null) {
                            string10 = "";
                        }
                        if ((string9 = pIIOSlotDataBean.getPciClass().toString()) == null) {
                            string9 = "";
                        }
                        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS " + string10 + "\n" + "*TM " + string3 + "\n" + "*SE " + string6 + "\n" + "*YL " + string8 + "-" + string7 + "\n" + "*VI " + string9 + "\n");
                    }
                }
            }
        }
        return vector;
    }

    public static String getVPD() throws CIMException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        String string = null;
        Enumeration enumeration = CIMUtils.getInstances("IBMHSC_Console");
        if (enumeration.hasMoreElements() && (cIMProperty = (cIMInstance = (CIMInstance)enumeration.nextElement()).getProperty("VPD")) != null && (cIMValue = cIMProperty.getValue()) != null) {
            string = (String)cIMValue.getValue();
            cIMProperty = cIMInstance.getProperty("HMCVersion");
            if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                string = string + "*FC ????????\n*DS Platform Firmware\n*RM " + (String)cIMValue.getValue() + "\n";
            }
        }
        if (string != null && string.length() > 0) {
            Date date = new Date();
            string = "*FC ????????\n*VC 20.0\n*N2 " + date + "\n" + string;
        }
        return string;
    }

    public static Vector getValues(Enumeration enumeration, Vector vector) throws CIMException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        String string = null;
        Vector<Vector<String>> vector2 = null;
        Vector<String> vector3 = null;
        Object var8_8 = null;
        if (enumeration != null && vector != null && vector.size() > 0) {
            String string2 = CIMUtils._getHostName();
            while (enumeration.hasMoreElements()) {
                var8_8 = enumeration.nextElement();
                if (var8_8 instanceof CIMInstance) {
                    cIMInstance = var8_8;
                } else {
                    cIMInstance = PIHscUtil.getCIMInstance(string2, var8_8, false);
                    if (cIMInstance == null) continue;
                }
                vector3 = new Vector<String>(vector.size());
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    string = "";
                    String string3 = (String)enumeration2.nextElement();
                    cIMProperty = cIMInstance.getProperty(string3);
                    if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null && (string = (String)cIMValue.getValue()) == null) {
                        string = "";
                    }
                    vector3.addElement(string);
                }
                if (vector2 == null) {
                    vector2 = new Vector<Vector<String>>();
                }
                vector2.addElement(vector3);
            }
        }
        return vector2;
    }

    public static String getValue(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        if (cIMInstance != null && (cIMProperty = cIMInstance.getProperty(string)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            return (String)cIMValue.getValue();
        }
        return null;
    }

    public static Enumeration getInstances(String string) throws CIMException {
        return CIMUtils.getInstances(string, new CIMObjectPath(string, "root/ibmhscS1_0"));
    }

    private static Enumeration getInstances(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        Enumeration enumeration = null;
        String string2 = CIMUtils._getHostName();
        if (cIMObjectPath != null) {
            enumeration = PIHscUtil.getCIMEnumInstances(string2, cIMObjectPath, true, false);
        }
        return enumeration;
    }

    private static String replaceFirst(String string, char c, char c2) {
        int n = 0;
        StringBuffer stringBuffer = null;
        if (string != null && (n = string.indexOf(c)) != -1) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(n, c2);
            return stringBuffer.toString();
        }
        return string;
    }

    public static Vector getPartitionProperties(String string, String string2, String string3) throws CIMException {
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration = null;
        Vector<String> vector = null;
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        String string4 = null;
        CIMObjectPath cIMObjectPath = null;
        String string5 = CIMUtils._getHostName();
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        enumeration = CIMUtils.getAssociators("IBMHSC_ComputerSystem", "IBMHSC_CompSysPartition", "IBMHSC_Partition", hashtable);
        while (enumeration.hasMoreElements()) {
            string4 = "";
            cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            cIMInstance = PIHscUtil.getCIMInstance(string5, cIMObjectPath, false);
            if (cIMInstance != null && (cIMProperty = cIMInstance.getProperty(string3)) != null && (cIMValue = cIMProperty.getValue()) != null && (string4 = (String)cIMValue.getValue()) == null) {
                string4 = "";
            }
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(string4);
        }
        return vector;
    }

    public static Vector getPartitions(String string, String string2) throws CIMException {
        return CIMUtils.getPartitionProperties(string, string2, "UserDefinedName");
    }

    public static Vector getPartitionKeyNames(String string, String string2) throws CIMException {
        return CIMUtils.getPartitionProperties(string, string2, "Name");
    }

    public static String _getHostName() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            if (string != null && string.length() > 0) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "localhost";
    }

    public static boolean isInSMPMode(String string, String string2) throws CIMException, IOException {
        CIMProperty cIMProperty = null;
        CIMInstance cIMInstance = null;
        CIMValue cIMValue = null;
        UnsignedInt8 unsignedInt8 = null;
        Hashtable<String, String> hashtable = null;
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        cIMInstance = CIMUtils.getInstance("IBMHSC_ComputerSystem", hashtable);
        if (cIMInstance != null) {
            cIMProperty = cIMInstance.getProperty("Mode");
            if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null && (unsignedInt8 = (UnsignedInt8)cIMValue.getValue()) != null) {
                return unsignedInt8.intValue() == 0;
            }
            throw new CIMException("");
        }
        throw new IOException("");
    }

    public static Hashtable getPartitionInfo() throws CIMException {
        Enumeration enumeration = null;
        Vector vector = null;
        Vector vector2 = null;
        Vector<String> vector3 = null;
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration2 = null;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = null;
        String string = CIMUtils._getHostName();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var12_12 = null;
        UnsignedInt8 unsignedInt8 = null;
        Hashtable<String, PartitionInfo> hashtable2 = null;
        Object var15_15 = null;
        Object var16_16 = null;
        String string5 = null;
        PartitionInfo partitionInfo = null;
        hashtable2 = new Hashtable<String, PartitionInfo>();
        vector3 = new Vector<String>(2);
        vector3.addElement("PlatformType");
        vector3.addElement("PlatformSerial");
        enumeration = CIMUtils.getInstances("IBMHSC_ComputerSystem");
        vector = CIMUtils.getValues(enumeration, vector3);
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                vector2 = (Vector)iterator.next();
                string2 = (String)vector2.elementAt(0);
                string3 = (String)vector2.elementAt(1);
                hashtable = new Hashtable<String, String>();
                hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
                hashtable.put("Name", string2 + '*' + string3);
                enumeration2 = CIMUtils.getAssociators("IBMHSC_ComputerSystem", "IBMHSC_CompSysPartition", "IBMHSC_Partition", hashtable);
                while (enumeration2.hasMoreElements()) {
                    partitionInfo = null;
                    string4 = null;
                    cIMObjectPath = (CIMObjectPath)enumeration2.nextElement();
                    cIMInstance = PIHscUtil.getCIMInstance(string, cIMObjectPath, false);
                    if (cIMInstance != null && (string4 = (String)CIMUtils.getPropertyValue(cIMInstance, "Name")) != null && (string5 = (String)CIMUtils.getPropertyValue(cIMInstance, "UserDefinedName")) != null && (unsignedInt8 = (UnsignedInt8)CIMUtils.getPropertyValue(cIMInstance, "PartitionState")) != null) {
                        partitionInfo = new PartitionInfo(string4, unsignedInt8, string5);
                    }
                    if (string4 == null || partitionInfo == null) continue;
                    hashtable2.put(string4, partitionInfo);
                }
            }
        }
        return hashtable2;
    }

    public static PartitionInfo getPartitionInfo(CIMInstance cIMInstance) throws CIMException {
        String string = null;
        UnsignedInt8 unsignedInt8 = null;
        String string2 = null;
        PartitionInfo partitionInfo = null;
        if (cIMInstance != null && (string = (String)CIMUtils.getPropertyValue(cIMInstance, "Name")) != null && (string2 = (String)CIMUtils.getPropertyValue(cIMInstance, "UserDefinedName")) != null && (unsignedInt8 = (UnsignedInt8)CIMUtils.getPropertyValue(cIMInstance, "PartitionState")) != null) {
            partitionInfo = new PartitionInfo(string, unsignedInt8, string2);
        }
        return partitionInfo;
    }

    public static Object getPropertyValue(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            return cIMValue.getValue();
        }
        return null;
    }

    public static String getHMCMTMS(String string, String string2) throws CIMException {
        Enumeration enumeration = null;
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = "";
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "->getHMCMTMS(" + string + ", " + string2 + ")");
        }
        if ((enumeration = CIMUtils.getInstances("CIM_Chassis")) != null && enumeration.hasMoreElements() && (cIMProperty = (cIMInstance = (CIMInstance)enumeration.nextElement()).getProperty("Model")) != null && (cIMValue = cIMProperty.getValue()) != null && (string4 = (String)cIMValue.getValue()) != null && (cIMProperty = cIMInstance.getProperty("SerialNumber")) != null && (cIMValue = cIMProperty.getValue()) != null && (string3 = (String)cIMValue.getValue()) != null) {
            string5 = string4.indexOf(45) != -1 ? string4 : (string4.length() < 4 ? string4 : string4.substring(0, 4) + "-" + string4.substring(4));
            string6 = string5 + '*' + string3;
        }
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "<-getHMCMTMS(...) returning " + string6);
        }
        return string6;
    }

    public static String getHMCMTM(String string, String string2) throws CIMException {
        String string3 = null;
        int n = 0;
        string3 = CIMUtils.getHMCMTMS(string, string2);
        if (string3.length() > 0 && (n = string3.indexOf(42)) != -1) {
            return string3.substring(0, n);
        }
        return "";
    }

    public static String getHMCMS(String string, String string2) throws CIMException {
        String string3 = null;
        int n = 0;
        string3 = CIMUtils.getHMCMTMS(string, string2);
        if (string3.length() > 0 && (n = string3.indexOf(42)) != -1) {
            return string3.substring(n + 1);
        }
        return "";
    }

    public static Hashtable getComponentsOfBPA(String string, String string2) throws CIMException {
        Hashtable<String, String> hashtable = null;
        Hashtable<String, Object> hashtable2 = null;
        CIMObjectPath cIMObjectPath = null;
        String string3 = null;
        String string4 = null;
        Vector vector = null;
        Vector<CIMProperty> vector2 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        Object var13_13 = null;
        CIMValue cIMValue = null;
        String string5 = CIMUtils._getHostName();
        hashtable2 = new Hashtable<String, Object>();
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_Frame");
        hashtable.put("Name", string + '*' + string2);
        cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscS1_0");
        if (cIMObjectPath != null) {
            Object object;
            if (hashtable != null) {
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    string3 = (String)object.nextElement();
                    string4 = (String)hashtable.get(string3);
                    cIMObjectPath.addKey(string3, new CIMValue((Object)string4));
                }
            }
            vector = new Vector();
            vector2 = new Vector<CIMProperty>();
            vector2.addElement(new CIMProperty("IODrawerMtms", new CIMValue(var9_9, new CIMDataType(29))));
            vector2.addElement(new CIMProperty("IOMatchingCECMtms", new CIMValue(var10_10, new CIMDataType(29))));
            vector2.addElement(new CIMProperty("IOCageNum", new CIMValue(var11_11, new CIMDataType(21))));
            vector2.addElement(new CIMProperty("CECMtms", new CIMValue(var12_12, new CIMDataType(29))));
            vector2.addElement(new CIMProperty("CECCageNum", new CIMValue(var13_13, new CIMDataType(21))));
            cIMValue = PIHscUtil.invokeCIMMethod(string5, cIMObjectPath, "GetFrameInfo", null, vector2);
            if (cIMValue != null) {
                Object object2;
                Vector vector3;
                object = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                if (object != null) {
                    vector3 = new Vector();
                    object2 = ((Vector)object).iterator();
                    while (object2.hasNext()) {
                        vector3.addElement(CIMUtils.replaceFirst((String)object2.next(), '*', '_'));
                    }
                    if (vector3.size() > 0) {
                        hashtable2.put("1", vector3);
                    }
                }
                if ((vector3 = (Vector)((CIMProperty)vector2.elementAt(3)).getValue().getValue()) != null) {
                    object2 = new Vector();
                    Iterator iterator = vector3.iterator();
                    while (iterator.hasNext()) {
                        ((Vector)object2).addElement(CIMUtils.replaceFirst((String)iterator.next(), '*', '_'));
                    }
                    if (((Vector)object2).size() > 0) {
                        hashtable2.put("0", object2);
                    }
                }
            }
        }
        if (hashtable2.size() == 0) {
            return null;
        }
        return hashtable2;
    }

    public static Vector getBPAs() throws CIMException {
        Enumeration enumeration = null;
        Vector<String> vector = null;
        String string = null;
        CIMObjectPath cIMObjectPath = null;
        CIMInstance cIMInstance = null;
        boolean bl = false;
        cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscS1_0");
        enumeration = CIMUtils.getInstances("IBMHSC_Frame", cIMObjectPath);
        while (enumeration.hasMoreElements()) {
            cIMInstance = (CIMInstance)enumeration.nextElement();
            bl = (Boolean)cIMInstance.getProperty("isFrame").getValue().getValue();
            if (!bl) continue;
            string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(CIMUtils.replaceFirst(string, '*', '_'));
        }
        return vector;
    }

    public static Vector getBPAs(String string, String string2) throws CIMException {
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration = null;
        Vector<String> vector = null;
        String string3 = null;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = null;
        String string4 = CIMUtils._getHostName();
        boolean bl = false;
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        enumeration = CIMUtils.getAssociators("IBMHSC_ComputerSystem", "IBMHSC_FrameCompSys", "IBMHSC_Frame", hashtable);
        while (enumeration.hasMoreElements()) {
            cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            cIMInstance = PIHscUtil.getCIMInstance(string4, cIMObjectPath, false);
            if (cIMInstance == null) continue;
            bl = (Boolean)cIMInstance.getProperty("isFrame").getValue().getValue();
            if (bl) {
                string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "Real frame found in getBPAs : " + string3);
                }
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement(CIMUtils.replaceFirst(string3, '*', '_'));
                continue;
            }
            if (Trace.LEVEL < 3) continue;
            Trace.trace(TRACE_MASKD, "Fake frame found in getBPAs.");
        }
        return vector;
    }

    public static String getSlotId(String string) {
        int n = 0;
        if (string != null && (n = string.indexOf(42)) != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String getCECMTM(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        if (string != null && (n = string.indexOf(42)) != -1 && string.length() > n + 1 && (n2 = string.indexOf(42, n + 1)) != -1) {
            string2 = string.substring(n + 1, n2);
        }
        return string2;
    }

    public static String getCECMS(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        if (string != null && (n = string.indexOf(42)) != -1 && string.length() > n + 1 && (n2 = string.indexOf(42, n + 1)) != -1 && string.length() > n2 + 1) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    public static boolean isSurveillanceEnabled(String string, String string2, String string3) {
        boolean bl;
        block9: {
            Hashtable<String, String> hashtable = null;
            boolean bl2 = false;
            boolean bl3 = false;
            CIMInstance cIMInstance = null;
            Enumeration enumeration = null;
            UnsignedInt8 unsignedInt8 = null;
            UnsignedInt8 unsignedInt82 = null;
            boolean bl4 = false;
            CIMInstance cIMInstance2 = null;
            CIMProperty cIMProperty = null;
            CIMValue cIMValue = null;
            CIMObjectPath cIMObjectPath = null;
            bl = false;
            UnsignedInt8 unsignedInt83 = null;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> isSurveillanceEnabled(" + string + ", " + string2 + ", " + string3 + ")");
            }
            try {
                hashtable = new Hashtable<String, String>();
                hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
                hashtable.put("Name", string2 + '*' + string3);
                cIMInstance2 = CIMUtils.getInstance("IBMHSC_ComputerSystem", hashtable);
                if (cIMInstance2 != null && (cIMProperty = cIMInstance2.getProperty("Mode")) != null && (cIMValue = cIMProperty.getValue()) != null && (unsignedInt82 = (UnsignedInt8)cIMValue.getValue()) != null) {
                    bl3 = true;
                    if (unsignedInt82.intValue() == 0) {
                        bl2 = true;
                    }
                }
                if (!bl3) break block9;
                if (bl2) {
                    bl = true;
                    break block9;
                }
                hashtable = new Hashtable();
                hashtable.put("CreationClassName", "IBMHSC_Partition");
                hashtable.put("Name", CIMUtils.makePartitionName(string2, string3, string));
                cIMInstance2 = CIMUtils.getInstance("IBMHSC_Partition", hashtable);
                if (cIMInstance2 == null || (unsignedInt83 = (UnsignedInt8)CIMUtils.getPropertyValue(cIMInstance2, "PartitionState")) == null || unsignedInt83.intValue() != 2 || (cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscS1_0")) == null) break block9;
                cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                cIMObjectPath.addKey("Name", new CIMValue((Object)CIMUtils.makePartitionName(string2, string3, string)));
                enumeration = PIHscUtil.getCIMAssociationInst(CIMUtils._getHostName(), cIMObjectPath, "IBMHSC_ActivatedLparProfile", "IBMHSC_LparProfile", "Element", "Setting", false, false, null);
                if (enumeration == null) break block9;
                while (enumeration.hasMoreElements()) {
                    cIMInstance = (CIMInstance)enumeration.nextElement();
                    if (cIMInstance == null) continue;
                    unsignedInt8 = (UnsignedInt8)CIMUtils.getPropertyValue(cIMInstance, "SFPSurveillance");
                    if (unsignedInt8 != null && unsignedInt8.intValue() == 1) {
                        bl = true;
                    }
                    break;
                }
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- isSurveillanceEnabled(...) returning " + bl);
        }
        return bl;
    }

    public static String makePartitionName(String string, String string2, String string3) {
        return string3 + '*' + string + '*' + string2;
    }
}

